import { Camera, Mail, Phone, MapPin } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={24} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">PhotoLab</h2>
            </div>
            <p className="footer-description">
              Профессиональные фотосессии. Превращаем моменты в искусство.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@photolab.ru">info@photolab.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Фотографическая, д. 15</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Портрет</a></li>
              <li><a href="#">Семейная</a></li>
              <li><a href="#">Love Story</a></li>
              <li><a href="#">Бренд</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>Пн-Пт: 10:00 - 20:00</li>
              <li>Сб-Вс: 11:00 - 19:00</li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 PhotoLab. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

